	.INCLUDE	"global.inc"
	.IMPORT	MUL8
	.IMPORT	DIVP8
	.EXPORT	RAYCAST

	.CODE
	
;**********************************************
;*
;* RAY CASTER CALCULATES INTERSECTION OF
;* RAY-X, RAY-Y, RAY-ANGLE WITH WALL
;* SEGMENT DATABASE. THE ALGORITHM USES
;* AN INCREMENTAL DDA TO FIND INTERSECTIONS.
;* COORDINATES ARE CALCULATED IN 8.8 FIXED
;* POINT AND CHECKED AGAINST INTEGER WALLS.
;* WALL DATABASE IS SAVED AS A HORIZONTAL/
;* VERTICAL PAIR. THE UPPER NIBBLE CONTAINS
;* AN INDEX TO A VERTICAL WALL SEGMENT,
;* THE LOWER NIBBLE CONTAINS AN INDEX TO A
;* HORIZONTAL WALL SEGMENT. A NIBBLE OF
;* ZERO REPRESENTS NO WALL. THE OBJECT
;* DATABASE IS CHECKED FOR HITS BASED ON
;* INTEGER CELLS.  AN OBJECT WILL OCCUPY
;* AN ENTIRE CELL CENTERD AT X.5, Y.5.
;* UP TO FOUR OBJECT HITS WILL BE STORED.
;* OBJECTS ARE SORTED FRONT TO BACK.
;*
;**********************************************
;**********************************************
;*
;* RAY - OBJECT / WALL INTERSECT ROUTINES.
;*
;**********************************************
;
; JUMP TO OCTANT ROUTINE
;
RAYCAST:	LDA	#$00	;CLEAR HIT COUNT
	STA	HITCNT
	LDA	RAYX	;PREVX = RAYX
	STA	PREVX
	LDA	RAYX+1
	STA	PREVX+1
	LDA	RAYY	;PREVY = RAYY
	STA	PREVY
	LDA	RAYY+1
	STA	PREVY+1
	LDX	MAPROW	;INIT WORKING POINTERS
	STX	MAPPTR
	LDX	MAPROW+1
	STX	MAPPTR+1
	LDX	OBJROW
	STX	OBJPTR
	LDX	OBJROW+1
	STX	OBJPTR+1
	LDX	RAYA
	TXA		;JUMP TO OCTANT
	AND	#$E0	;SPECIFIC ROUTINE
	LSR
	LSR
	LSR
	LSR
	TAY
	LDA	OCTANT+1,Y
	PHA
	LDA	OCTANT,Y
	PHA
	TXA
	AND	#$1F
	RTS
;
;    X+ Y+ OCTANT 0
;
XPYP:	TAY		;A=RAYANGLE MOD 64
	LDA	FRACHYP,Y
	STA	DLEN
	LDX	MINLEN,Y	;INCY = (1-FRAC(RAYX))*MINORLEN[ANGLE]+PREVY
	STX	DY
	LDA	#$00	;1-FRAC(RAYX)
	SEC
	SBC	PREVX
	BEQ	XPYPXI	;RAYX IS INT
	JSR	MUL8
	TAX
XPYPXI:	TXA
	CLC
	ADC	PREVY
	STA	INCY
	LDA	#$00
	ADC	PREVY+1
	STA	INCY+1
	LDY	PREVX+1
XPYPCHKY:	CMP	PREVY+1	;A = INCYH, Y = PREVXH
	BEQ	XPYPCHKX
	LDA	(OBJPTR),Y
	BNE	XPYPHITOBJY
XPYPCHKWALLY:	LDA	OBJPTR	;UPDATE OBJPTR
	CLC
	ADC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	ADC	#$00
	STA	OBJPTR+1
	LDA	MAPPTR	;UPDATE MAPPTR
	CLC
	ADC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	ADC	#$00
	STA	MAPPTR+1
	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	XPYPHITY
XPYPCHKX:	LDA	(OBJPTR),Y
	BNE	XPYPHITOBJX
XPYPCHKWALLX:	INY		;INC X COORD
	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	XPYPHITX
XPYPINCY:	LDA	INCY
	STA	PREVY
	CLC		;INC Y COORD
	ADC	DY
	STA	INCY
	LDA	INCY+1
	STA	PREVY+1	;PREVY = INCY
	ADC	#$00
	STA	INCY+1
	JMP	XPYPCHKY
XPYPHITOBJY:	CPY	RAYX+1
	BEQ	XPYPCHKWALLY
	JSR	XPYPADDOBJY
	BCC	XPYPCHKWALLY
XPYPHITOBJX:	CPY	RAYX+1
	BEQ	XPYPCHKWALLX
	JSR	XPYPADDOBJX
	BCC	XPYPCHKWALLX
XPYPHITY:	STA	HITOBJ	;HIT HORIZ WALL
	LDA	#$00
	STA	HITY	;HITY = INT(INCY)
	LDA	INCY+1
	STA	HITY+1
	LDA	INCY	;HITX = 1-FRAC(INCY)/DY+INT(PREVX)
	LDX	DY
	JSR	DIVP8
	EOR	#$FF
	STA	HITX
	SEC
	SBC	RAYX
	TAX
	TYA		;Y=PREVXH
	STA	HITX+1
	SBC	RAYX+1
	JMP	CALCDISTSCALE
XPYPHITX:	STA	HITOBJ	;HIT VERT WALL
	LDA	INCY
	STA	HITY	;HITY = INCY
	LDA	INCY+1
	STA	HITY+1
	LDA	#$00	;HITX = INCX
	STA	HITX
	SEC
	SBC	RAYX
	TAX
	TYA		;Y = INCXH
	STA	HITX+1
	SBC	RAYX+1
	JMP	CALCDISTSCALE
;
;    Y+ X+ OCTANT 1
;
YPXP:	EOR	#$1F	;NEGATE ANGLE
	TAY
	INY
	LDA	FRACHYP,Y
	STA	DLEN
	LDX	MINLEN,Y	;INCX = (1-FRAC(RAYY))*MINORLEN[ANGLE]+PREVX
	STX	DX
	LDA	#$00	;1-FRAC(RAYY)
	SEC
	SBC	PREVY
	BEQ	YPXPYI	;RAYY IS INT
	JSR	MUL8
	TAX
YPXPYI:	TXA
	CLC
	ADC	PREVX
	STA	INCX
	LDA	#$00
	ADC	PREVX+1
	STA	INCX+1
	LDX	PREVY+1
YPXPCHKX:	TAY		;Y = INCXH, X = PREVYH
	CPY	PREVX+1
	BEQ	YPXPCHKY
	DEY
	LDA	(OBJPTR),Y
	BNE	YPXPHITOBJX
YPXPCHKWALLX:	INY
	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	YPXPHITX
YPXPCHKY:	LDA	(OBJPTR),Y
	BNE	YPXPHITOBJY
YPXPCHKWALLY:	INX		;INC Y COORD
	LDA	OBJPTR	;UPDATE OBJPTR
	CLC
	ADC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	ADC	#$00
	STA	OBJPTR+1
	LDA	MAPPTR	;UPDATE MAPPTR
	CLC
	ADC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	ADC	#$00
	STA	MAPPTR+1
	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	YPXPHITY
YPXPINCX:	LDA	INCX	;INC X COORD
	STA	PREVX
	CLC
	ADC	DX
	STA	INCX
	LDA	INCX+1
	STA	PREVX+1	;PREVX = INCX
	ADC	#$00
	STA	INCX+1
	JMP	YPXPCHKX
YPXPHITOBJX:	CPX	RAYY+1
	BEQ	YPXPCHKWALLX
	JSR	YPXPADDOBJX
	BCC	YPXPCHKWALLX
YPXPHITOBJY:	CPX	RAYY+1
	BEQ	YPXPCHKWALLY
	JSR	YPXPADDOBJY
	BCC	YPXPCHKWALLY
YPXPHITX:	STA	HITOBJ	;HIT VERT WALL
	LDA	#$00
	STA	HITX	;HITX = INT(INCX)
	STY	HITX+1
	STX	HITY+1
	LDA	INCX	;HITY = 1-FRAC(INCX)/DX+INT(PREVY)
	LDX	DX
	JSR	DIVP8
	EOR	#$FF
	STA	HITY
	SEC
	SBC	RAYY
	TAX
	LDA	HITY+1
	SBC	RAYY+1
	JMP	CALCDISTSCALE
YPXPHITY:	STA	HITOBJ	;HIT HORIZ WALL
	LDA	INCX
	STA	HITX	;HITX = INCX
	STY	HITX+1
	LDA	#$00	;HITY = INCY
	STA	HITY
	STX	HITY+1	;X = INCYH
	SEC
	SBC	RAYY
	TAX
	LDA	HITY+1
	SBC	RAYY+1
	JMP	CALCDISTSCALE
;
;    Y+ X- OCTANT 2
;
YPXM:	TAY
	LDA	FRACHYP,Y
	STA	DLEN
	LDX	MINLEN,Y	;INCX = PREVX-(1-FRAC(RAYY))*MINORLEN[ANGLE]
	STX	DX
	LDA	#$00	;1-FRAC(RAYY)
	SEC
	SBC	PREVY
	BEQ	YPXMYI	;RAYY IS INT
	JSR	MUL8
	TAX
YPXMYI:	STX	INCX
	LDA	PREVX
	SEC
	SBC	INCX
	STA	INCX
	LDA	PREVX+1
	SBC	#$00
	STA	INCX+1
	LDX	PREVY+1
YPXMCHKX:	TAY		;Y = INCXH, X = PREVYH
	CPY	PREVX+1
	BEQ	YPXMCHKY
	INY
	LDA	(OBJPTR),Y
	BNE	YPXMHITOBJX
YPXMCHKWALLX:	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	YPXMHITX
	DEY
YPXMCHKY:	LDA	(OBJPTR),Y
	BNE	YPXMHITOBJY
YPXMCHKWALLY:	INX		;INC Y COORD
	LDA	OBJPTR	;UPDATE OBJPTR
	CLC
	ADC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	ADC	#$00
	STA	OBJPTR+1
	LDA	MAPPTR	;UPDATE MAPPTR
	CLC
	ADC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	ADC	#$00
	STA	MAPPTR+1
	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	YPXMHITY
YPXMINCX:	LDA	INCX	;INC X COORD
	STA	PREVX
	SEC
	SBC	DX
	STA	INCX
	LDA	INCX+1
	STA	PREVX+1	;PREVX = INCX
	SBC	#$00
	STA	INCX+1
	JMP	YPXMCHKX
YPXMHITOBJX:	CPX	RAYY+1
	BEQ	YPXMCHKWALLX
	JSR	YPXMADDOBJX
	BCC	YPXMCHKWALLX
YPXMHITOBJY:	CPX	RAYY+1
	BEQ	YPXMCHKWALLY
	JSR	YPXMADDOBJY
	BCC	YPXMCHKWALLY
YPXMHITX:	STA	HITOBJ	;HIT VERT WALL
	LDA	#$00
	STA	HITX	;HITX = INT(INCX)
	STY	HITX+1
	STX	HITY+1
	LDA	INCX	;HITY = 1-FRAC(INCX)/DX+INT(PREVY)
	EOR	#$FF
	LDX	DX
	JSR	DIVP8
	EOR	#$FF
	STA	HITY
	SEC
	SBC	RAYY
	TAX
	LDA	HITY+1
	SBC	RAYY+1
	JMP	CALCDISTSCALE
YPXMHITY:	STA	HITOBJ	;HIT HORIZ WALL
	LDA	INCX
	STA	HITX	;HITX = INCX
	STY	HITX+1
	LDA	#$00	;HITY = INCY
	STA	HITY
	STX	HITY+1	;X = INCYH
	SEC
	SBC	RAYY
	TAX
	LDA	HITY+1
	SBC	RAYY+1
	JMP	CALCDISTSCALE
;
;    X- Y+ OCTANT 3
;
XMYP:	EOR	#$1F	;NEGATE ANGLE
	TAY
	INY
	LDA	FRACHYP,Y
	STA	DLEN
	LDX	MINLEN,Y	;INCY = FRAC(RAYX)*MINORLEN[ANGLE]+PREVY
	STX	DY
	LDA	PREVX
	BEQ	XMYPXI	;RAYX IS INT
	JSR	MUL8
XMYPXI:	CLC
	ADC	PREVY
	STA	INCY
	LDA	#$00
	ADC	PREVY+1
	STA	INCY+1
	LDY	PREVX+1
XMYPCHKY:	CMP	PREVY+1	;A = INCYH, Y = INCXH
	BEQ	XMYPCHKX
	LDA	(OBJPTR),Y
	BNE	XMYPHITOBJY
XMYPCHKWALLY:	LDA	OBJPTR	;UPDATE OBJPTR
	CLC
	ADC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	ADC	#$00
	STA	OBJPTR+1
	LDA	MAPPTR	;UPDATE MAPPTR
	CLC
	ADC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	ADC	#$00
	STA	MAPPTR+1
	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	XMYPHITY
XMYPCHKX:	LDA	(OBJPTR),Y
	BNE	XMYPHITOBJX
XMYPCHKWALLX:	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	XMYPHITX
	DEY		;INC X COORD
XMYPINCY:	LDA	INCY
	STA	PREVY
	CLC		;INC Y COORD
	ADC	DY
	STA	INCY
	LDA	INCY+1
	STA	PREVY+1	;PREVY = INCY
	ADC	#$00
	STA	INCY+1
	JMP	XMYPCHKY
XMYPHITOBJY:	CPY	RAYX+1
	BEQ	XMYPCHKWALLY
	JSR	XMYPADDOBJY
	BCC	XMYPCHKWALLY
XMYPHITOBJX:	CPY	RAYX+1
	BEQ	XMYPCHKWALLX
	JSR	XMYPADDOBJX
	BCC	XMYPCHKWALLX
XMYPHITY:	STA	HITOBJ	;HIT HORIZ WALL
	LDA	#$00
	STA	HITY	;HITY = INT(INCY)
	LDA	INCY+1
	STA	HITY+1
	LDA	INCY	;HITX = FRAC(INCY)/DY+INT(INCX)
	LDX	DY
	JSR	DIVP8
	STA	HITX
	LDA	RAYX
	SEC
	SBC	HITX
	TAX
	STY	HITX+1	;Y = INCXH
	LDA	RAYX+1
	SBC	HITX+1
	JMP	CALCDISTSCALE
XMYPHITX:	STA	HITOBJ	;HIT VERT WALL
	LDA	INCY
	STA	HITY	;HITY = INCY
	LDA	INCY+1
	STA	HITY+1
	LDA	#$00	;HITX = INCX
	STA	HITX
	LDA	RAYX
	SEC
	SBC	HITX
	TAX
	STY	HITX+1	;Y = INCXH
	LDA	RAYX+1
	SBC	HITX+1
	JMP	CALCDISTSCALE
;
;    X- Y- OCTANT 4
;
XMYM:	TAY
	LDA	FRACHYP,Y
	STA	DLEN
	LDX	MINLEN,Y	;INCY = PREVY-FRAC(RAYX)*MINORLEN[ANGLE]
	STX	DY
	LDA	PREVX
	BEQ	XMYMXI	;RAYX IS INT
	JSR	MUL8
XMYMXI:	STA	INCY
	LDA	PREVY
	SEC
	SBC	INCY
	STA	INCY
	LDA	PREVY+1
	SBC	#$00
	STA	INCY+1
	LDY	PREVX+1
XMYMCHKY:	CMP	PREVY+1	;A = INCYH, Y = INCXH
	BEQ	XMYMCHKX
	LDA	(OBJPTR),Y
	BNE	XMYMHITOBJY
XMYMCHKWALLY:	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	XMYMHITY
	LDA	OBJPTR	;UPDATE OBJPTR
	SEC
	SBC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	SBC	#$00
	STA	OBJPTR+1
	LDA	MAPPTR	;UPDATE MAPPTR
	SEC
	SBC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	SBC	#$00
	STA	MAPPTR+1
XMYMCHKX:	LDA	(OBJPTR),Y
	BNE	XMYMHITOBJX
XMYMCHKWALLX:	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	XMYMHITX
	DEY		;INC X COORD
XMYMINCY:	LDA	INCY
	STA	PREVY
	SEC		;INC Y COORD
	SBC	DY
	STA	INCY
	LDA	INCY+1
	STA	PREVY+1	;PREVY = INCY
	SBC	#$00
	STA	INCY+1
	JMP	XMYMCHKY
XMYMHITOBJY:	CPY	RAYX+1
	BEQ	XMYMCHKWALLY
	JSR	XMYMADDOBJY
	BCC	XMYMCHKWALLY
XMYMHITOBJX:	CPY	RAYX+1
	BEQ	XMYMCHKWALLX
	JSR	XMYMADDOBJX
	BCC	XMYMCHKWALLX
XMYMHITY:	STA	HITOBJ	;HIT HORIZ WALL
	LDA	#$00
	STA	HITY	;HITY = INT(PREVY)
	LDA	PREVY+1
	STA	HITY+1
	LDA	INCY	;HITX = (1-FRAC(INCY)/DY)+INT(INCX)
	EOR	#$FF
	LDX	DY
	JSR	DIVP8
	STA	HITX
	LDA	RAYX
	SEC
	SBC	HITX
	TAX
	STY	HITX+1	;Y = INCXH
	LDA	RAYX+1
	SBC	HITX+1
	JMP	CALCDISTSCALE
XMYMHITX:	STA	HITOBJ	;HIT VERT WALL
	LDA	INCY
	STA	HITY	;HITY = INCY
	LDA	INCY+1
	STA	HITY+1
	LDA	#$00	;HITX = INCX
	STA	HITX
	LDA	RAYX
	SEC
	SBC	HITX
	TAX
	STY	HITX+1	;Y = INCXH
	LDA	RAYX+1
	SBC	HITX+1
	JMP	CALCDISTSCALE
;
;    Y- X- OCTANT 5
;
YMXM:	EOR	#$1F	;NEGATE ANGLE
	TAY
	INY
	LDA	FRACHYP,Y
	STA	DLEN
	LDX	MINLEN,Y	;INCX = PREVX-FRAC(RAYY)*MINORLEN[ANGLE]
	STX	DX
	LDA	PREVY
	BEQ	YMXMYI	;RAYY IS INT
	JSR	MUL8
YMXMYI:	STA	INCX
	LDA	PREVX
	SEC
	SBC	INCX
	STA	INCX
	LDA	PREVX+1
	SBC	#$00
	STA	INCX+1
	LDX	PREVY+1
YMXMCHKX:	TAY		;Y = INCXH, X = PREVYH
	CPY	PREVX+1
	BEQ	YMXMCHKY
	INY
	LDA	(OBJPTR),Y
	BNE	YMXMHITOBJX
YMXMCHKWALLX:	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	YMXMHITX
	DEY
YMXMCHKY:	LDA	(OBJPTR),Y
	BNE	YMXMHITOBJY
YMXMCHKWALLY:	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	YMXMHITY
	DEX		;INC Y COORD
	LDA	OBJPTR	;UPDATE OBJPTR
	SEC
	SBC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	SBC	#$00
	STA	OBJPTR+1
	LDA	MAPPTR	;UPDATE MAPPTR
	SEC
	SBC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	SBC	#$00
	STA	MAPPTR+1
YMXMINCX:	LDA	INCX	;INC X COORD
	STA	PREVX
	SEC
	SBC	DX
	STA	INCX
	LDA	INCX+1
	STA	PREVX+1	;PREVX = INCX
	SBC	#$00
	STA	INCX+1
	JMP	YMXMCHKX
YMXMHITOBJX:	CPX	RAYY+1
	BEQ	YMXMCHKWALLX
	JSR	YMXMADDOBJX
	BCC	YMXMCHKWALLX
YMXMHITOBJY:	CPX	RAYY+1
	BEQ	YMXMCHKWALLY
	JSR	YMXMADDOBJY
	BCC	YMXMCHKWALLY
YMXMHITX:	STA	HITOBJ	;HIT VERT WALL
	LDA	#$00
	STA	HITX	;HITX = INT(INCX)
	STY	HITX+1
	STX	HITY+1
	LDA	INCX	;HITY = 1-FRAC(INCX)/DX+INT(PREVY)
	EOR	#$FF
	LDX	DX
	JSR	DIVP8
	STA	HITY
	LDA	RAYY
	SEC
	SBC	HITY
	TAX
	LDA	RAYY+1
	SBC	HITY+1
	JMP	CALCDISTSCALE
YMXMHITY:	STA	HITOBJ	;HIT HORIZ WALL
	LDA	INCX
	STA	HITX	;HITX = INCX
	STY	HITX+1
	LDA	#$00	;HITY = INCY
	STA	HITY
	STX	HITY+1	;X = INCYH
	LDA	RAYY
	SEC
	SBC	HITY
	TAX
	LDA	RAYY+1
	SBC	HITY+1
	JMP	CALCDISTSCALE
;
;    Y- X+ OCTANT 6
;
YMXP:	TAY
	LDA	FRACHYP,Y
	STA	DLEN
	LDX	MINLEN,Y	;INCX = FRAC(RAYY)*MINORLEN[ANGLE]+PREVX
	STX	DX
	LDA	PREVY	;FRAC(RAYY)
	BEQ	YMXPYI	;RAYY IS INT
	JSR	MUL8
YMXPYI:	CLC
	ADC	PREVX
	STA	INCX
	LDA	#$00
	ADC	PREVX+1
	STA	INCX+1
	LDX	PREVY+1
YMXPCHKX:	TAY		;Y = INCXH, X = PREVYH
	CPY	PREVX+1
	BEQ	YMXPCHKY
	DEY
	LDA	(OBJPTR),Y
	BNE	YMXPHITOBJX
YMXPCHKWALLX:	INY
	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	YMXPHITX
YMXPCHKY:	LDA	(OBJPTR),Y
	BNE	YMXPHITOBJY
YMXPCHKWALLY:	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	YMXPHITY
	DEX		;INC Y COORD
	LDA	OBJPTR	;UPDATE OBJPTR
	SEC
	SBC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	SBC	#$00
	STA	OBJPTR+1
	LDA	MAPPTR	;UPDATE MAPPTR
	SEC
	SBC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	SBC	#$00
	STA	MAPPTR+1
YMXPINCX:	LDA	INCX	;INC X COORD
	STA	PREVX
	CLC
	ADC	DX
	STA	INCX
	LDA	INCX+1
	STA	PREVX+1	;PREVX = INCX
	ADC	#$00
	STA	INCX+1
	JMP	YMXPCHKX
YMXPHITOBJX:	CPX	RAYY+1
	BEQ	YMXPCHKWALLX
	JSR	YMXPADDOBJX
	BCC	YMXPCHKWALLX
YMXPHITOBJY:	CPX	RAYY+1
	BEQ	YMXPCHKWALLY
	JSR	YMXPADDOBJY
	BCC	YMXPCHKWALLY
YMXPHITX:	STA	HITOBJ	;HIT VERT WALL
	LDA	#$00
	STA	HITX	;HITX = INT(INCX)
	STY	HITX+1
	STX	HITY+1
	LDA	INCX	;HITY = FRAC(INCX)/DX+INT(PREVY)
	LDX	DX
	JSR	DIVP8
	STA	HITY
	LDA	RAYY
	SEC
	SBC	HITY
	TAX
	LDA	RAYY+1
	SBC	HITY+1
	JMP	CALCDISTSCALE
YMXPHITY:	STA	HITOBJ	;HIT HORIZ WALL
	LDA	INCX
	STA	HITX	;HITX = INCX
	STY	HITX+1
	LDA	#$00	;HITY = INCY
	STA	HITY
	STX	HITY+1	;X = INCYH
	LDA	RAYY
	SEC
	SBC	HITY
	TAX
	LDA	RAYY+1
	SBC	HITY+1
	JMP	CALCDISTSCALE
;
;    X+ Y- OCTANT 7
;
XPYM:	EOR	#$1F	;NEGATE ANGLE
	TAY
	INY
	LDA	FRACHYP,Y
	STA	DLEN
	LDX	MINLEN,Y	;INCY = PREVY-(1-FRAC(RAYX))*MINORLEN[ANGLE]
	STX	DY
	LDA	#$00	;1-FRAC(RAYX)
	SEC
	SBC	PREVX
	BEQ	XPYMXI	;RAYX IS INT
	JSR	MUL8
	TAX
XPYMXI:	TXA
	STA	INCY
	LDA	PREVY
	SEC
	SBC	INCY
	STA	INCY
	LDA	PREVY+1
	SBC	#$00
	STA	INCY+1
	LDY	PREVX+1
XPYMCHKY:	CMP	PREVY+1	;A = INCYH, Y = PREVXH
	BEQ	XPYMCHKX
	LDA	(OBJPTR),Y
	BNE	XPYMHITOBJY
XPYMCHKWALLY:	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	XPYMHITY
	LDA	OBJPTR	;UPDATE OBJPTR
	SEC
	SBC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	SBC	#$00
	STA	OBJPTR+1
	LDA	MAPPTR	;UPDATE MAPPTR
	SEC
	SBC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	SBC	#$00
	STA	MAPPTR+1
XPYMCHKX:	LDA	(OBJPTR),Y
	BNE	XPYMHITOBJX
XPYMCHKWALLX:	INY		;INC X COORD
	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	XPYMHITX
XPYMINCY:	LDA	INCY
	STA	PREVY
	SEC		;INC Y COORD
	SBC	DY
	STA	INCY
	LDA	INCY+1
	STA	PREVY+1	;PREVY = INCY
	SBC	#$00
	STA	INCY+1
	JMP	XPYMCHKY
XPYMHITOBJY:	CPY	RAYX+1
	BEQ	XPYMCHKWALLY
	JSR	XPYMADDOBJY
	BCC	XPYMCHKWALLY
XPYMHITOBJX:	CPY	RAYX+1
	BEQ	XPYMCHKWALLX
	JSR	XPYMADDOBJX
	BCC	XPYMCHKWALLX
XPYMHITY:	STA	HITOBJ	;HIT HORIZ WALL
	LDA	#$00
	STA	HITY	;HITY = INT(PREVY)
	LDA	PREVY+1
	STA	HITY+1
	LDA	INCY	;HITX = 1-(1-FRAC(INCY))/DY+INT(PREVX)
	EOR	#$FF
	LDX	DY
	JSR	DIVP8
	EOR	#$FF
	STA	HITX
	SEC
	SBC	RAYX
	TAX
	TYA		;Y=PREVXH
	STA	HITX+1
	SBC	RAYX+1
	JMP	CALCDISTSCALE
XPYMHITX:	STA	HITOBJ	;HIT VERT WALL
	LDA	INCY
	STA	HITY	;HITY = INCY
	LDA	INCY+1
	STA	HITY+1
	LDA	#$00	;HITX = INCX
	STA	HITX
	SEC
	SBC	RAYX
	TAX
	TYA		;Y = INCXH
	STA	HITX+1
	SBC	RAYX+1
	JMP	CALCDISTSCALE
;**********************************************
;*
;* OBJECT HIT ADD ROUTINES.
;*
;**********************************************
;
;    X+ Y+ OCTANT 0
;
XPYPADDOBJY:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	XPYPADDOBJYEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	ASL
	ASL
	STA	REVA
	LDA	INCY
	SEC
	SBC	REVA
	BCS	XPYPREMOBJ
	STA	HITX,Y
	LDA	#$80
	SEC
	SBC	RAYX
	STA	HITDIST,Y
	LDA	TMPY
	SBC	RAYX+1
	STA	HITDIST+1,Y
XPYPADDOBJYEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
XPYPREMOBJ:	LDA	HITCNT
	SEC
	SBC	#$08
	STA	HITCNT
	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
XPYPADDOBJX:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	XPYPADDOBJXEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	ASL
	ASL
	STA	REVA
	LDA	INCY
	SEC
	SBC	REVA
	BCC	XPYPREMOBJ
	STA	HITX,Y
	LDA	#$80
	SEC
	SBC	RAYX
	STA	HITDIST,Y
	LDA	TMPY
	SBC	RAYX+1
	STA	HITDIST+1,Y
XPYPADDOBJXEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
;
;    Y+ X+ OCTANT 1
;
YPXPADDOBJX:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	YPXPADDOBJXEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	EOR	#$1F
	ASL
	ASL
	STA	REVA
	LDA	INCX
	SEC
	SBC	REVA
	BCS	YPXPREMOBJ
	EOR	#$FF
	STA	HITX,Y
	LDA	#$80
	SEC
	SBC	RAYY
	STA	HITDIST,Y
	LDA	TMPX
	SBC	RAYY+1
	STA	HITDIST+1,Y
YPXPADDOBJXEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
YPXPREMOBJ:	LDA	HITCNT
	SEC
	SBC	#$08
	STA	HITCNT
	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
YPXPADDOBJY:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	YPXPADDOBJYEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	EOR	#$1F
	ASL
	ASL
	STA	REVA
	LDA	INCX
	SEC
	SBC	REVA
	BCC	YPXPREMOBJ
	EOR	#$FF
	STA	HITX,Y
	LDA	#$80
	SEC
	SBC	RAYY
	STA	HITDIST,Y
	LDA	TMPX
	SBC	RAYY+1
	STA	HITDIST+1,Y
YPXPADDOBJYEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
;
;    Y+ X- OCTANT 2
;
YPXMADDOBJX:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	YPXMADDOBJXEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	ASL
	ASL
	CLC
	ADC	INCX
	BCC	YPXMREMOBJ
	EOR	#$FF
	STA	HITX,Y
	LDA	#$80
	SEC
	SBC	RAYY
	STA	HITDIST,Y
	LDA	TMPX
	SBC	RAYY+1
	STA	HITDIST+1,Y
YPXMADDOBJXEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
YPXMREMOBJ:	LDA	HITCNT
	SEC
	SBC	#$08
	STA	HITCNT
	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
YPXMADDOBJY:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	YPXMADDOBJYEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	ASL
	ASL
	CLC
	ADC	INCX
	BCS	YPXMREMOBJ
	EOR	#$FF
	STA	HITX,Y
	LDA	#$80
	SEC
	SBC	RAYY
	STA	HITDIST,Y
	LDA	TMPX
	SBC	RAYY+1
	STA	HITDIST+1,Y
YPXMADDOBJYEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
;
;    X- Y+ OCTANT 3
;
XMYPADDOBJY:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	XMYPADDOBJYEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	EOR	#$1F
	ASL
	ASL
	STA	REVA
	LDA	INCY
	SEC
	SBC	REVA
	BCS	XMYPREMOBJ
	EOR	#$FF
	STA	HITX,Y
	LDA	RAYX
	SEC
	SBC	#$80
	STA	HITDIST,Y
	LDA	RAYX+1
	SBC	TMPY
	STA	HITDIST+1,Y
XMYPADDOBJYEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
XMYPREMOBJ:	LDA	HITCNT
	SEC
	SBC	#$08
	STA	HITCNT
	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
XMYPADDOBJX:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	XMYPADDOBJXEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	EOR	#$1F
	ASL
	ASL
	STA	REVA
	LDA	INCY
	SEC
	SBC	REVA
	BCC	XMYPREMOBJ
	EOR	#$FF
	STA	HITX,Y
	LDA	RAYX
	SEC
	SBC	#$80
	STA	HITDIST,Y
	LDA	RAYX+1
	SBC	TMPY
	STA	HITDIST+1,Y
XMYPADDOBJXEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
;
;    X- Y- OCTANT 4
;
XMYMADDOBJY:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	XMYMADDOBJYEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	ASL
	ASL
	CLC
	ADC	INCY
	BCC	XMYMREMOBJ
	EOR	#$FF
	STA	HITX,Y
	LDA	RAYX
	SEC
	SBC	#$80
	STA	HITDIST,Y
	LDA	RAYX+1
	SBC	TMPY
	STA	HITDIST+1,Y
XMYMADDOBJYEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
XMYMREMOBJ:	LDA	HITCNT
	SEC
	SBC	#$08
	STA	HITCNT
	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
XMYMADDOBJX:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	XMYMADDOBJXEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	ASL
	ASL
	CLC
	ADC	INCY
	BCS	XMYMREMOBJ
	EOR	#$FF
	STA	HITX,Y
	LDA	RAYX
	SEC
	SBC	#$80
	STA	HITDIST,Y
	LDA	RAYX+1
	SBC	TMPY
	STA	HITDIST+1,Y
XMYMADDOBJXEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
;
;    Y- X- OCTANT 5
;
YMXMADDOBJX:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	YMXMADDOBJXEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	EOR	#$1F
	ASL
	ASL
	CLC
	ADC	INCX
	BCC	YMXMREMOBJ
	STA	HITX,Y
	LDA	RAYY
	SEC
	SBC	#$80
	STA	HITDIST,Y
	LDA	RAYY+1
	SBC	TMPX
	STA	HITDIST+1,Y
YMXMADDOBJXEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
YMXMREMOBJ:	LDA	HITCNT
	SEC
	SBC	#$08
	STA	HITCNT
	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
YMXMADDOBJY:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	YMXMADDOBJYEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	EOR	#$1F
	ASL
	ASL
	CLC
	ADC	INCX
	BCS	YMXMREMOBJ
	STA	HITX,Y
	LDA	RAYY
	SEC
	SBC	#$80
	STA	HITDIST,Y
	LDA	RAYY+1
	SBC	TMPX
	STA	HITDIST+1,Y
YMXMADDOBJYEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
;
;    Y- X+ OCTANT 6
;
YMXPADDOBJX:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	YMXPADDOBJXEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	ASL
	ASL
	STA	REVA
	LDA	INCX
	SEC
	SBC	REVA
	BCS	YMXPREMOBJ
	STA	HITX,Y
	LDA	RAYY
	SEC
	SBC	#$80
	STA	HITDIST,Y
	LDA	RAYY+1
	SBC	TMPX
	STA	HITDIST+1,Y
YMXPADDOBJXEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
YMXPREMOBJ:	LDA	HITCNT
	SEC
	SBC	#$08
	STA	HITCNT
	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
YMXPADDOBJY:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	YMXPADDOBJYEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	ASL
	ASL
	STA	REVA
	LDA	INCX
	SEC
	SBC	REVA
	BCC	YMXPREMOBJ
	STA	HITX,Y
	LDA	RAYY
	SEC
	SBC	#$80
	STA	HITDIST,Y
	LDA	RAYY+1
	SBC	TMPX
	STA	HITDIST+1,Y
YMXPADDOBJYEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
;
;    X+ Y- OCTANT 7
;
XPYMADDOBJY:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	XPYMADDOBJYEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	EOR	#$1F
	ASL
	ASL
	CLC
	ADC	INCY
	BCC	XPYMREMOBJ
	STA	HITX,Y
	LDA	#$80
	SEC
	SBC	RAYX
	STA	HITDIST,Y
	LDA	TMPY
	SBC	RAYX+1
	STA	HITDIST+1,Y
XPYMADDOBJYEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
XPYMREMOBJ:	LDA	HITCNT
	SEC
	SBC	#$08
	STA	HITCNT
	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS
XPYMADDOBJX:	STA	TMPA
	STX	TMPX
	STY	TMPY
	LDA	HITCNT
	CMP	#$10
	BCS	XPYMADDOBJXEX
	ADC	#$08
	STA	HITCNT
	TAY
	LDA	TMPA
	AND	#OBJTYPESPRTMSK
	STA	HITOBJ,Y
	LDA	RAYA
	AND	#$1F
	EOR	#$1F
	ASL
	ASL
	CLC
	ADC	INCY
	BCS	XPYMREMOBJ
	STA	HITX,Y
	LDA	#$80
	SEC
	SBC	RAYX
	STA	HITDIST,Y
	LDA	TMPY
	SBC	RAYX+1
	STA	HITDIST+1,Y
XPYMADDOBJXEX:	LDY	TMPY
	LDX	TMPX
	LDA	TMPA
	CLC
	RTS

;**************************************
;*
;* CALCULATE DISTANCE FROM RAY-X,Y TO
;* HITX,Y BASED IN HYPOTENUSE OF A RIGHT
;* TRIANGLE WITH ANGLE RAY-ANGLE.  DLEN
;* CONTAINS THE FRACTIONAL LENGTH
;* OF THE HYPOTENUSE, THE INTEGER PART
;* IS ASSUMED TO BE ONE. THE LENGTH
;* OF THE ADJOINING TRIANGLE EDGE PASSED
;* IN A:X.
;*
;**************************************
CALCDISTSCALE:
	STX	HITDIST
	STA	HITDIST+1
	LDA	DLEN	;MUL MAJORLEN*HYP
	JSR	MUL8	;USING PARTIAL PRODS
	CLC		;AS MAJORLEN*(1+DLEN)
	ADC	HITDIST
	STA	HITDIST
	LDA	HITDIST+1
	TAY
	ADC	#$00	
	STA	HITDIST+1
	LDX	DLEN
	TYA
	JSR	MUL8
	TAY
	TXA
	CLC
	ADC	HITDIST
	STA	HITDIST
	TYA
	ADC	HITDIST+1
	STA	HITDIST+1
	RTS
	
	.DATA
;
; OCTANT ROUTINE TABLE
;
OCTANT:	.ADDR	XPYP-1, YPXP-1, YPXM-1, XMYP-1, XMYM-1, YMXM-1, YMXP-1, XPYM-1
;
; FRACTIONAL HYPOTENUSE FOR 0-45 DEGREES
;
FRACHYP:	.BYTE	$00, $00, $00, $01, $01, $02, $03, $04
	.BYTE	$05, $06, $08, $0A, $0C, $0E, $10, $12
	.BYTE	$15, $18, $1B, $1F, $22, $26, $2A, $2F
	.BYTE	$34, $39, $3F, $45, $4B, $52, $5A, $61
	.BYTE	$6A
;
; MINOR AXIS LENGTH OF VIEW TRIANGLE
;
MINLEN:	.BYTE	$00, $06, $0D, $13, $19, $20, $26, $2C
	.BYTE	$33, $39, $40, $47, $4E, $55, $5C, $63
	.BYTE	$6A, $71, $79, $81, $89, $91, $99, $A2
	.BYTE	$AB, $B4, $BE, $C8, $D2, $DD, $E8, $F4
	.BYTE	$FF	;THIS IS A CHEAT, SHOULD BE 1.0 (0100)
